/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.system.util;

import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesException;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesParser;
import com.ibm.hwmca.fw.service.system.util.UnsupportedDTDException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileFilter;

public class ServiceInterfaces {
    static final String TRACE_MASKT = "XRVF062T";
    static final String TRACE_MASKF = "XRVF062F";
    static final String TRACE_MASKD = "XRVF062D";
    static ServiceInterfacesParser sip = new ServiceInterfacesParser();

    public static synchronized void add(String filename) throws ServiceInterfacesException {
        ServiceInterfaces.add(new File(filename));
    }

    public static synchronized void add(File file) throws ServiceInterfacesException {
        sip.parseFile(file);
    }

    public static synchronized void add(String[] filenames) throws ServiceInterfacesException {
        for (int aii = 0; aii < filenames.length; ++aii) {
            ServiceInterfaces.add(filenames[aii]);
        }
    }

    public static synchronized void add(File[] files) throws ServiceInterfacesException {
        for (int aii = 0; aii < files.length; ++aii) {
            ServiceInterfaces.add(files[aii]);
        }
    }

    public static synchronized void addAllFiles(String directoryName) throws ServiceInterfacesException {
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            throw new ServiceInterfacesException("specified name is not a directory[" + directoryName + "]");
        }
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                return pathName.getName().toLowerCase().endsWith(".xml");
            }
        });
        for (int aii = 0; aii < files.length; ++aii) {
            try {
                ServiceInterfaces.add(files[aii]);
                continue;
            }
            catch (ServiceInterfacesException se) {
                if (se instanceof UnsupportedDTDException) continue;
                throw se;
            }
        }
    }

    public static synchronized void reset() {
        sip = new ServiceInterfacesParser();
    }

    private ServiceInterfaces() {
    }

    public static Object getFactory(Object keyObject, String factoryInterface) throws ServiceInterfacesException {
        Trace.trace(TRACE_MASKT, "<> ServiceInterfaces.getFactory( keyObject(" + keyObject + "), factoryInterface(" + factoryInterface + ") )");
        if (keyObject == null) {
            Trace.trace(TRACE_MASKT, "<-! ServiceInterfaces.getFactory null keyObject parameter passed");
            throw new ServiceInterfacesException("ServiceInterfaces.getFactory() null keyObject parameter passed");
        }
        return ServiceInterfaces.getFactory(keyObject.getClass().getName(), factoryInterface);
    }

    public static Object getFactory(String key, String factoryInterface) throws ServiceInterfacesException {
        return sip.getFactory(key, factoryInterface);
    }
}

